/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNmethod_h
#define SNmethod_h 1

#include <bool.h>
#include "SNunit.h"
#include "SNunitList.h"
#include "SNstream.h"
#include "SNstreamList.h"
#include "SNvolList.h"
#include "Rind.h"

class SNmessage;
class SNvolatile;
class SNexport;
class SNimport;
class Protocol;
class inst;
class instList;

enum neck {M_DESCEND, M_TERMINATE};

struct SNmethod {
friend class SNtree;
  int descend;
  gList(SNunit) actions;
  SNstreamList& streams;
  SNvolatileList volatiles;
  SNimport* importAction;
  Protocol* selectorPcol;

  int numberOfSendselves;

  void export(SNexport*, SNimport*, instList&);
// public:
  SNmethod(SNstreamList& slp)
    : streams(slp), descend(M_TERMINATE), importAction(0) {}
  ~SNmethod() { delete &streams; }
  int& descends() { return descend; }
  gList(SNunit)& get_actions() { return actions; }
  SNstreamList& get_streams() { return streams; }
  SNvolatileList& get_volatiles() { return volatiles; }
  void print(ostream&);
  void print_rc();
  void mapImport(SNimport* import) { importAction = import; }
  void split();
  void printProtocol();
  int selectorLength();
  bool isCloseMethod();
  bool isDefaultMethod();
  void putPseudoInst(instList&);
  void putEntranceLabel(char*, instList&);
  void encode(instList&);	// SNclass Υ᥽åɤξ硣
  void encode(SNexport*, inst*, instList&);
				// SNvolatileΥ᥽åɤξ硣

  friend bool operator==(SNmethod&, SNmethod&);
  Protocol* selector() { return selectorPcol; }
  void setSelector(SNmessage*);
  void setDescend(int dsn) { descend = dsn; }
  void markUnusedVars();
  int LineNumber();
};

#endif SNmethod_h
