/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "errmsg.h"
#include "SNerror.h"
#include "SNmethod.h"
#include "SNclass.h"
#include "SNvolatile.h"
#include "SNvolList.h"
#include "SNexport.h"
#include "SNimport.h"
#include "Protocol.h"
#include "closePcol.h"
#include "defPcol.h"
#include "inst.h"
#include "RegTable.h"
#include "CDdescend.h"
#include "CDterminate.h"
#include "CDlabel.h"
#include "CDjump.h"
#include "CDconnect.h"
#include "nameStream.h"
#include "SNtree.h"

void SNmethod::export(SNexport* exp, SNimport* imp, instList& code)
{
  int len = exp->length();
  for (int i = 0 ; i < len ; i++) {
    Rind r = exp->varTable[i]->node->regno();
    // Rind r = exp->varTable[i]->regno;
    SNunit* vp = imp->varTable[i];
    if (vp->inletExp()) {
      // SNmessage::encodeAtGroundΥȤ򻲾ȡ
      autoClose(vp->connectTo(r, code), code);
    }
    else {
      Rind Rlocal = vp->encode(code);
      code.add(new CDconnect(Rlocal, r));
      // SNunit::encodeAsSelectorArgΥȤ򻲾ȡ
      // autoClose(r, code);
      // ϴְ㤤
      regTable.decrement(r);
      regTable.decrement(Rlocal);
      // 
    }
  }
}

void SNmethod::print(ostream& ost)
{
  gList_iterator(SNunit) acts(&actions);
  SNunit* a = acts();
  ost << a; // print method selector
  ost << (descend == M_DESCEND ? " -> " : " -| ");
  if (importAction) ost << importAction;
  a = acts.next();
  if (a) ost << "\n\t" << a;
  for (a = acts.next() ; a ; a = acts.next()) {
    ost << ",\n\t" << a;
  }
}

void SNmethod::print_rc()
{
  gList_iterator(SNunit) actionIt(&actions);
  actionIt()->print(cout);
  cout << ":\n";
  gMHList_iterator(SNstream) streamIt(&streams);
  for (SNstream* streamp = streamIt() ; streamp ;
       streamp = streamIt.next()) {
    streamp->print_rc();
  }
  SNvolatileListItr volatileIt(volatiles);
  for (SNvolatile* vp = volatileIt() ; vp ; vp = volatileIt.next()) {
    vp->print_rc();
  }
}

void SNmethod::split()
{
  if (importAction) importAction->split();
  gList_iterator(SNunit) acts(&actions);
  for (SNunit* up = acts() ; up ; up = acts.next()) {
    up->split(0);
  }
}

void SNmethod::printProtocol()
{
  cout << selectorPcol;
}

int SNmethod::selectorLength()
{
  return selectorPcol->length();
}


bool SNmethod::isCloseMethod()
{
  return selectorPcol == closeProtocol::uniqueInstance;
}

bool SNmethod::isDefaultMethod()
{
  return selectorPcol == defaultProtocol::uniqueInstance;
}

void SNmethod::putPseudoInst(instList& code)
{
  selectorPcol->addPImethod(code);
}

void SNmethod::putEntranceLabel(char* vname, instList& code)
{
  selectorPcol->putEntranceLabel(vname, code);
}

void SNmethod::encode(instList& code)
{
  SNtree::currentMethod = this;
  numberOfSendselves = 0;
  int len = actions.length();
  inst* descentInst = (descend == M_DESCEND
		       ? (inst*)new CDdescend
		       : (inst*)new CDterminate);
  regTable.init(selectorLength());
  gList_iterator(SNunit) acts(&actions);
  SNmessage* msg = (SNmessage*)acts();
  msg->encodeAtGround(code, 0);
  if (--len == 0) code.add(descentInst);
  for (SNunit* a = acts.next() ; a ; a = acts.next()) {
    if (--len) a->encodeAtGround(code);
    else a->encodeAtGround(code, descentInst);
  }
}

void SNmethod::encode(SNexport* exports, inst* descentInst, instList& code)
{
  SNtree::currentMethod = this;
  numberOfSendselves = 0;
  export(exports, importAction, code);
  int len = actions.length();
  descentInst = (descend == M_DESCEND
		 ? descentInst
		 : (inst*)new CDterminate);
  gList_iterator(SNunit) acts(&actions);
  SNmessage* msg = (SNmessage*)acts();
  msg->encodeAtGround(code, importAction ? importAction->length() : 0);
  SNunit* last_action = actions.last();
  if (last_action == (SNunit*)msg) code.add(descentInst);
  else {
    for (SNunit* a = acts.next() ; a != last_action ; a = acts.next()) {
      a->encodeAtGround(code);
    }
    last_action->encodeAtGround(code, descentInst);
  }
}

bool operator==(SNmethod& a, SNmethod& b)
{
  return *(a.selectorPcol) == *(b.selectorPcol);
}

void SNmethod::setSelector(SNmessage* selectorp)
{
  selectorPcol = selectorp->protocol();
  actions.push(selectorp);
}

void SNmethod::markUnusedVars()
{
  gMHList_iterator(SNstream) varIt(&streams);
  for (SNstream* vp = varIt(); vp ; vp = varIt.next()) {
    if (vp->isUnusedVars()) {
      Name mname = selectorPcol->string();
      sprintf(ErrorMessageBuffer,
	      "variable '%s' in method '%s' has no outlet",
	      vp->get_name(),
	      (char*)mname);
      SNerror(ErrorMessageBuffer, LineNumber());
    }
  }
}

int SNmethod::LineNumber()
{
  if (actions.length() == 0) return 0;
  gList_iterator(SNunit) itr(&actions);
  return itr()->LineNumber();
}
