/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNmessage_h
#define SNmessage_h 1

#include "SNunit.h"

class intList;
class instList;

class SNmessage : public SNunit {
friend class Protocol;
  int arity;
  SNunit* func;
  SNunit** args;
  void private_split();

protected:
  Protocol* pcol;

public:
  SNmessage(SNunit*, int);
  ~SNmessage();
  SNunit* functor() { return func; }
  void print(ostream&);
  SNunit*& operator[](int i) { return args[i]; }
  void setProtocol(Protocol* pp) { pcol = pp; }
  Protocol* protocol() { return pcol; }

  virtual void split(int = 0) { private_split(); }

  virtual void encodeAtGround(instList&, Rind = 0);
  intList* encodeArgs(instList&);
};

#endif SNmessage_h
