/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNmessage.h"
#include "SNerror.h"
#include "CDconnect.h"
#include "intList.h"
#include "Protocol.h"
#include "RegTable.h"

SNmessage::SNmessage(SNunit* f, int n) : SNunit("message")
{
  func = f;
  arity = n;
  if (arity > 0) args = new SNunitptr[n];
  else args = 0;
  for (int i = 0 ; i < n ; i++) args[i] = 0;
}

SNmessage::~SNmessage()
{
  delete func;
  if (args != 0) {
    for (int i = 0 ; i < arity ; i++) {
      if (args[i]) delete args[i];
    }
    delete args;
  }
}

void SNmessage::print(ostream& ost)
{
  ost << ":" << func;
  if (arity > 0) {
    ost << "(";
    assert(args != 0);
    if (args[0] == 0) ost << "(* null *)";
    else ost << args[0];
    for (int i = 1 ; i < arity ; i++) {
      ost << ", ";
      if (args[i] != 0) ost << args[i];
      else ost << "(* null *)";
    }
    ost << ")";
  }
}

void SNmessage::private_split()
{
  for (int i = 0 ; i < arity ; i++) {
    args[i]->split(1);		// If args[i] is inlet-expr,
				// it should ignore '1'
  }
}

void SNmessage::encodeAtGround(instList& code, Rind rTop)
{
  for (int i = 0 ; i < arity ; i++) {
    if (args[i]->inletExp()) {
      // :foo(^_)ϡ :foo(^A) -> A = ^_ Ǥ롣
      // connectTo ֤쥸ʤǤA)ˤĤƤϡ
      // autoClose뤳ȤԤƤ롣
      // ^_ ⤷^X ǡX$1X$2ؤλȤƱ᥽åˤС
      // XˤĤƤϡconnectTo autoClose롣
      // connect ˤä close פˤʤϡ
      // closeFlag ߤƤϤ顢
      autoClose(args[i]->connectTo(rTop + i, code), code);
      // Ǥäơ
      // regTable.decrement(args[i]->connectTo(rTop + i, code));
      // ǤϤʤ
    }
    else args[i]->encodeAsSelectorArg(rTop + i, code);
  }
}

intList* SNmessage::encodeArgs(instList& code)
{
  intList* argRinds = new intList;
  for (int i = 0 ; i < arity ; i++) {
    Rind r = args[i]->encode(code);
    argRinds->add(r + 1);	// intList ̾Ȥ΢ʢ
  }				// ʤΤǡ1 ­
				// r == 0 ξߺѤƤ
				// ʥˡ
  return argRinds;
}

