/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNlt_h
#define SNlt_h 1

#include "SNbincond.h"
#include "CDif_gt.h"
#include "CDgt.h"

class SNlt : public SNbincond {
  virtual char* opName() { return "<"; }
  virtual void addDirectJump(Rind r1, Rind r2, char* t, char* f,
			     instList& code) {
    code.add(new CDif_gt(r2, r1, t, f));
  }
  virtual void encodeMessageSending(Rind r1, Rind r2, Rind r3,
				    instList& code) {
    code.add(new CDgt(r2, r1, r3));
  }

public:
  SNlt(SNunit* a1, SNunit* a2) : SNbincond("<", a1, a2) {}
};

#endif SNlt_h





