/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include "SNlist.h"
#include "SNnil.h"
#include "SNerror.h"
#include "RegTable.h"
#include "CDclistii.h"
#include "CDclistio.h"
#include "CDclistoi.h"
#include "CDclistoo.h"
#include "CDsplit_n.h"

SNlist::SNlist(int n) : SNunit("list")
{
  len = n;
  if (len > 0) elts = new SNunitptr[n];
  else elts = 0;
  for (int i = 0 ; i < n ; i++) elts[i] = 0;
  cdr = 0;
}

SNlist::~SNlist()
{
  if (elts != 0) {
    for (int i = 0 ; i < len ; i++) {
      if (elts[i]) delete elts[i];
    }
    delete elts;
  }
  if (cdr != 0) delete cdr;
}

void SNlist::print(ostream& ost)
{
  if (len > 0) {
    ost << "[";
    assert(elts != 0);
    if (elts[0] == 0) ost << "(* null *)";
    else ost << elts[0];
    for (int i = 1 ; i < len ; i++) {
      ost << ", ";
      if (elts[i] != 0) ost << elts[i];
      else ost << "(* null *)";
    }
    if (cdr != 0)  ost << " | " << cdr;
    ost << "]";
  }
  assert(FALSE);
}

void SNlist::split(int n)
{
  splitCount = n;
  for (int i = 0 ; i < len ; i++) {
    elts[i]->split(1);
  }
  if (cdr) cdr->split(1);
}

Rind SNlist::encode(instList& code)
{
  int i = len;
  Rind Rcdr = (cdr ? cdr : SNnil)->encode(code);
  if (cdr && cdr->inletExp()) {
    Rind r = regTable.newReg();
    regTable.set(r, 1);
    SNunit* car = elts[--i];
    Rind Rcar = car->encode(code);
    if (car->inletExp())
      code.add(new CDcreate_listii(r, Rcar, Rcdr));
    else
      code.add(new CDcreate_listoi(r, Rcar, Rcdr));
    autoClose(Rcar, code);
    Rcdr = r;
  }
  while (i > 0) {
    Rind r = regTable.newReg();
    regTable.set(r, 1);
    SNunit* car = elts[--i];
    Rind Rcar = car->encode(code);
    if (car->inletExp())
      code.add(new CDcreate_listio(r, Rcar, Rcdr));
    else
      code.add(new CDcreate_listoo(r, Rcar, Rcdr));
    autoClose(Rcar, code);
    autoClose(Rcdr, code);
    Rcdr = r;
  }
  if (splitCount > 1) {
    code.add(new CDsplit_n(Rcdr, splitCount - 1));
  }
  return Rcdr;
}
