/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNissimple_h
#define SNissimple_h 1

#include "SNuncond.h"
#include "CDissimple.h"
#include "CDifsimple.h"

class SNissimple : public SNuncond {
  Rind encodeAsInterface(char*, char*, instList&);
  virtual void addDirectJump(Rind r, char* t, char* f, instList& code) {
    code.add(new CDif_issimple(r, t, f));
  }
  virtual void encodeMessageSending(Rind r1, Rind r2, instList& code) {
    code.add(new CDissimple(r1, r2));
  }

public:
  SNissimple(SNunit* a) : SNuncond("issimple", a) {};
  char* opName() { return "issimple"; }
};

#endif SNissimple_h
