/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNislot_h
#define SNislot_h 1

#include <stream.h>
#include "SNunit.h"

class instList;
class SNname;

class SNislot : public SNunit {
  SNname& name;
public:
  SNislot(SNname*);
  ~SNislot() { delete &name; }
  void print(ostream& ost) { ost << "@" << name; }
  void split(int) {}
  int inletExp() { return 1; }	// It's inlet.
  Rind encode(instList&);	// Get inlet slot.
  void encodeAtGround(instList&);
				// Connects to $sink.
  Rind connected(SNunit*, instList&);
				// Inlet slot shouldn't be connected
				// at places other than ground.
  Rind connectTo(Rind, instList&);
				// Ordinary connection.
  void connectedAtGround(SNunit*, instList&);
				// Set inlet slot.
  Rind connectToVolatile(instList& code, char* l) { return encode(code); }
};

#endif SNislot_h

