/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include <stream.h>
#include <stdlib.h>
#include <string.h>
#include "RegTable.h"
#include "SNname.h"
#include "SNislot.h"
#include "CDsetinlet.h"
#include "CDgetinlet.h"
#include "CDcsink.h"		// create_sink
#include "CDconnect.h"

SNislot::SNislot(SNname* nm) : SNunit("islot"), name(*nm) {}

Rind SNislot::encode(instList& code)
{
  Rind r = regTable.newReg();
  regTable.set(r);
  code.add(new CDget_inlet(r, name));
  return r;
}

void SNislot::encodeAtGround(instList& code)
{
  Rind r = encode(code);
  Rind Rsink = regTable.newReg();
  code.add(new CDcreate_sink(Rsink));
  code.add(new CDconnect(Rsink, r));
				// These two instructions should be
				// replaced by a 'connect_to_sink.'
  regTable.decrement(r);
}

Rind SNislot::connected(SNunit* inlet, instList& code)
{
  assert(FALSE);
  // not reached; the following line is a dummy.
  return -1;
}

Rind SNislot::connectTo(Rind outlet, instList& code)
{
  Rind inlet = encode(code);
  code.add(new CDconnect(outlet, inlet));
  regTable.decrement(inlet);	// inlet ¦иȤ򸺤餹
  regTable.decrement(outlet);	// outlet ¦иȤ򸺤餹
  regTable.connected(outlet);	// outlet ¦closeFlag򲼤
  return outlet;
}

void SNislot::connectedAtGround(SNunit* inlet, instList& code)
{
  Rind r = inlet->encode(code);
  code.add(new CDset_inlet(r, name));
#ifdef DOUBTFUL
  regTable.decrement(r);
#else
  autoClose(r, code);
#endif
}
