/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNisbuiltin_h
#define SNisbuiltin_h 1

#include "SNuncond.h"
#include "CDisbuiltin.h"
#include "CDifbuiltin.h"

class SNisbuiltin : public SNuncond {
  Rind encodeAsInterface(char*, char*, instList&);
  virtual void addDirectJump(Rind r, char* t, char* f, instList& code) {
    code.add(new CDif_isbuiltin(r, t, f));
  }
  virtual void encodeMessageSending(Rind r1, Rind r2, instList& code) {
    code.add(new CDisbuiltin(r1, r2));
  }

public:
  SNisbuiltin(SNunit* a) : SNuncond("isbuiltin", a) {};
  char* opName() { return "isbuiltin"; }
};

#endif SNisbuiltin_h
