/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNinlet_h
#define SNinlet_h 1

#include "SNstream.h"

class SNstreamList;

class SNinlet : public SNunit {
  char* name;
  SNstream* stream;
public:
  SNinlet(char* n) : SNunit("inlet") { name = n; stream = 0; }
  SNinlet(SNstream* s) : SNunit("inlet") {
    stream = s;
    s->count(ORD_INLET);	// inlet νиȤ
				// ORD_INLET ν˵Ͽ롣
  }
  void setStream(SNstream* s) { stream = s; }
  SNstream* Stream() { return stream; }
  char* Name() { return name; }
  void print(ostream&);
  int inletExp() { return 1; }
  void split(int) {}
  Rind encode(instList& code) { return stream->encode(ORD_OUTLET, code); }
				//  ORD_OUTLET Ǥ褤
				// ORD_INLET ǤϤʤ
  void encodeAtGround(instList&);
  Rind connected(SNunit*, instList&);
  Rind connectTo(Rind, instList&);
  Rind connectToVolatile(instList& code, char* l) { return encode(code); }

  Rind regno() { return stream->regno(); }
  void setRegno(Rind r) { return stream->setRegno(ORD_OUTLET, r); }

  static SNinlet* create(char*, SNstreamList*);
};

#endif SNinlet_h
