/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include <stream.h>
#include <stdlib.h>
#include "RegTable.h"
#include "SNinlet.h"
#include "SNstreamList.h"
#include "CDconnect.h"
#include "CDcsink.h"
#include "CDsplit_n.h"
#include "CDclose.h"

void SNinlet::print(ostream& ost)
{
  if (stream) ost << "^" << stream;
  else ost << "^" << name;
}

void SNinlet::encodeAtGround(instList& code)
{
  Rind r = encode(code);
  Rind Rsink = regTable.newReg();
  code.add(new CDcreate_sink(Rsink));
  code.add(new CDconnect(Rsink, r));
				// These two instructions should be
				// replaced by a 'connect_to_sink.'
  autoClose(r, code);
}

Rind SNinlet::connected(SNunit* inlet, instList& code)
{
  assert(FALSE);
  // not reached; the following line is a dummy.
  return -1;
}

Rind SNinlet::connectTo(Rind outlet, instList& code)
{
  assert(!stream->isSink());
  gList_iterator(orderCount) ocit(&stream->get_appearances());
  ocit();			 // inlet order : discarded
  orderCount* ocp = ocit.next(); // outlet order
  orderCount* locp = ocit.next(); // lower order
  Rind r = stream->regno(ocp->order);
  if (r >= 0 || locp) {		// ˥쥸ޤäƤ뤫
				// ޤʣν̤ outlet 硣
    if (r < 0) r = stream->createJoints(ocp->order, code);
    code.add(new CDconnect(outlet, r));
    autoClose(r, code);		// inlet ¦ʬνиȤ򸺤餹
    //	outlet ¦ʬνиȤϥͥȤ餷ƤϤʤϤ
    //	㤨С3 = ^X = ^Y ʤС
    //	(ground (connect (connect 3 (inlet X)) (inlet Y)))
    //	ˤơ ground 餹٤Ǥ롣
    //	
    //	regTable.decrement(outlet); // outlet ¦иȤ򸺤餹
    //	ϴְ㤤
    //	ޤgroundɬפʤcloseԤ٤Ǥ롣
    //	connect  outlet ¦ close ɬפ뤳Ȥ
    //	ʤϤ
    //	regTable.connected(outlet); // outlet ¦closeFlag򲼤
    //	ϴְ㤤ޤinlet¦Ĵ٤ơɬפʤclose
    //	Ф褦 autoClose(r, code)ԤäƤ뤫顢
    //	regTable.add(outlet, 0, OnOff(ocp->split < 1));
    //	ˤäơcloseFlag outlet¦ɬפϤʤ
    //	⤽⡢ξϡinlet¦Υ쥸
    //	outlet¦Υ쥸·ʤ顢close̴
    //	٤Ǥ롣
  }
  else {			// outlet ν̤Ĥǡ
				// 쥸̤ξ硣
    regTable.add(outlet, ocp->count, OnOff(ocp->split < 1));
    if (ocp->split > 1) {
      code.add(new CDsplit_n(outlet, ocp->split - 1));
    }
    //	June 18. 1991.
    //	inlet topOrderνиȤʬΤǡ
    //	ǲäocp->countˤinletʬνиȤϴޤޤƤʤ
    //	äơιԤפˤʤä
    //	regTable.decrement(outlet); // inlet ¦ʬνиȤ򸺤餹
//  Ʊ
//  autoClose(outlet, code);	// outlet¦ʬνиȤ򸺤餹
    ocp->regno = outlet;	// 쥸 outlet ˤ롣
  }
  return outlet;
}

SNinlet* SNinlet::create(char* n, SNstreamList* streams)
{
  SNstream* srmp = streams->findOrMake(n);
  srmp->count(ORD_INLET);
  SNinlet* ip = new SNinlet(n);
  ip->setStream(srmp);
  return ip;
}
