/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNimport_h
#define SNimport_h 1

// SNimport : ܥ饿륯饹Υ᥽åɤˤ롢
//	      ѿ͢ɽ

#include <stream.h>
#include "RegTable.h"
#include "SNunit.h"
#include "SNunitArray.h"

class instList;
class SNmethod;
class SNexport;

class SNimport {
friend class SNimportItr;
  friend void SNmethod::export(SNexport*, SNimport*, instList&);

  SNunitArray varTable;
public:
  SNimport(int l) : varTable(l) {}
  SNunit*& operator[](int i) { return varTable[i]; }
  int length() { return varTable.length(); }
  void print(ostream&);
  void split();
  void encode(instList&);
};

inline ostream& operator<<(ostream& ost, SNimport* ip)
{
  ip->print(ost);
}

struct SNimportItr : SNunitArrayItr {
  SNimportItr(SNimport& im) : (im.varTable) {}
};

#endif SNimport_h
