/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNimport.h"
#include "RegTable.h"
#include "CDconnect.h"

void SNimport::print(ostream& ost)
{
  if (varTable.length() == 0) return;
  ost << "// imported vars : ";
  SNunitArrayItr vars(varTable);
  SNunit* vp = vars();
  vp->print(ost);
  for (vp = vars.next() ; vp ; vp = vars.next()) {
    ost << ", ";
    vp->print(ost);
  }
}

void SNimport::split()
{
  SNunitArrayItr vars(varTable);
  for (SNunit* vp = vars() ; vp ; vp = vars.next()) {
    vp->split(1);
  }
}

void SNimport::encode(instList& code)
{
  for (int i = 0 ; i < length() ; i++) {
    if (varTable[i]->inletExp()) {
      autoClose(varTable[i]->connectTo(i, code), code);
    }
    else {
      Rind r = varTable[i]->encode(code);
      code.add(new CDconnect(r, i));
      autoClose(r, code);
    }
  }
}

