/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include "SNerror.h"
#include "SNint.h"
#include "SNfvector.h"
#include "RegTable.h"
#include "CDseti.h"
#include "CDseto.h"
#include "CDcint.h"

SNfilledvector::SNfilledvector(int l) : SNvector(new SNint(l)), len(l)
{
  if (l > 0) v = new SNunitptr[l];
  else v = 0;
  for (int i = 0 ; i < l ; i++) v[i] = 0;
}

void SNfilledvector::print(ostream& ost)
{
  ost << "{";
  if (len > 0) {
    assert(v != 0);
    if (v[0] == 0) ost << "(* null *)";
    else ost << v[0];
    for (int i = 1 ; i < len ; i++) {
      ost << ", ";
      if (v[i] != 0) ost << v[i];
      else ost << "(* null *)";
    }
  }
  ost << "}";
}

void SNfilledvector::split(int n)
{
  SNvector::split(n + len);
  for (int i = 0 ; i < len ; i++) {
    v[i]->split(1);
  }
}

Rind SNfilledvector::encode(instList& code)
{
  Rind Rvec = SNvector::encode(code);
  if (len == 0) return Rvec;
  Rind Rindex = regTable.newReg();
  regTable.set(Rindex, 1);
  for (int i = 0 ; i < len ; i++) {
    code.add(new CDcreate_integer(Rindex, i));
    SNunit* arg = (*this)[i];
    Rind Rarg = arg->encode(code);
    autoClose(Rarg, code);
    code.add(arg->inletExp()
	     ? (inst*)new CDseti(Rvec, Rindex, Rarg)
	     : (inst*)new CDseto(Rvec, Rindex, Rarg));
  }
  regTable.decrement(Rindex);
  return Rvec;
}
