/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNfloat_h
#define SNfloat_h 1

#include <builtin.h>
#include "SNliteral.h"
#include "CDcfloat.h"		// Create float

class SNfloat : public SNliteral {
  float value;

  virtual void encodeCreation(Rind r, instList& code) {
    code.add(new CDcreate_sfloat(r, value));
  }

public:
  SNfloat(float& d) : SNliteral("float") { value = d; }

  void print(ostream& ost) { ost << "0f" << dtoa(value, 'g', 0, 6); }
};

#endif SNfloat_h
