/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNfgnmtd_h
#define SNfgnmtd_h 1

#include "numlabel.h"
#include "SNunit.h"
#include "SNstring.h"
#include "SNmethod.h"

class FgnLinkage;
class C_Linkage;
class CppLinkage;
class FgnArgSpec;
class FgnArgSpecList;
class FgnArgSpecListItr;
class FgnValArgSpec;
class FgnVarArgSpec;
class FgnRetValSpec;
class SNforeignMethod;

class intList;

enum FgnLinkType {
  FgnLinkTypeC = 1,
  FgnLinkTypeCpp
};

class FgnLinkage {
protected:
  enum FgnLinkType type;
  Name typename;
  int lineNumber;

public:
  static FgnLinkage* instance(FgnLinkType);

  FgnLinkage(enum FgnLinkType t , Name& tname)
    : type(t), typename(tname) {}
  void LineNumber(int l) { lineNumber = l; }
  int LineNumber() { return lineNumber; }
  enum FgnLinkType Type() { return type; }
  Name TypeName() { return typename; }
  virtual Name linkName(Name&) = 0;
};

class C_Linkage : public FgnLinkage {
public:
  C_Linkage() : FgnLinkage(FgnLinkTypeC, "C") {}
  virtual Name linkName(Name&);
};

class CppLinkage : public FgnLinkage {
public:
  CppLinkage() : FgnLinkage(FgnLinkTypeCpp, "C++") {}
  virtual Name linkName(Name&);
};

extern C_Linkage C_linkage;
extern CppLinkage Cpplinkage;

enum ForeignType {
  FgnTypeInteger,
  FgnTypeDouble,
  FgnTypeString,
  FgnTypeForeign
};

char * FgnTypeName(enum ForeignType);

enum FgnArgSpecType {
  FgnArgSpecTypeVal,
  FgnArgSpecTypeVar
};

class FgnArgSpec : public SNunit { // pure virtual
  int lineNumber;

public:
  FgnArgSpec(char* name) : SNunit(name) {}
  void LineNumber(int l) { lineNumber = l; }
  int LineNumber() { return lineNumber; }
  virtual bool isArgSpecTypeOf(enum FgnArgSpecType ast) = 0;
  virtual void split(int);
  virtual SNunit* Var() = 0;
  virtual void Var(SNunit*) = 0;
  virtual enum ForeignType type() = 0;
  virtual void type(enum ForeignType) = 0;
  FgnValArgSpec* asValSpec();
  FgnVarArgSpec* asVarSpec();
  virtual void split() = 0;
};

declare(gList, FgnArgSpec);

class FgnArgSpecList : public gList(FgnArgSpec) {
public:
  FgnArgSpecList() {}
  ~FgnArgSpecList() {}
  intList* encodeArgs(instList&);
};

class FgnArgSpecListItr : public gList_iterator(FgnArgSpec) {
public:
  FgnArgSpecListItr(FgnArgSpecList* l) : ( (gList(FgnArgSpec)*) l ) {}
  FgnValArgSpec* ValSpec();
  FgnValArgSpec* nextValSpec();
  FgnVarArgSpec* VarSpec();
  FgnVarArgSpec* nextVarSpec();
};

class FgnArg {
protected:
  SNunit* var;
  enum ForeignType frntype;
public:
  FgnArg(SNunit* v, enum ForeignType ft) : var(v), frntype(ft) {}
  ~FgnArg() { delete var; }
  SNunit* Var() { return var; }
  void Var(SNunit* v) { var = v; }
  enum ForeignType type() { return frntype; }
  void type(enum ForeignType t) { frntype = t; }
  void split();
};

class FgnValArgSpec : public FgnArgSpec {
  FgnArg fgnArg;
public:
  FgnValArgSpec(SNunit* v, enum ForeignType ft)
    : FgnArgSpec("fgnValArg"), fgnArg(v, ft) {}
  virtual void print(ostream&);
  virtual void split();
  virtual bool isArgSpecTypeOf(FgnArgSpecType ast) {
    return (ast == FgnArgSpecTypeVal ? TRUE : FALSE);
  }
  virtual SNunit* Var() { return fgnArg.Var(); }
  virtual void Var(SNunit* v) { fgnArg.Var(v); }
  virtual enum ForeignType type() { return fgnArg.type(); }
  virtual void type(enum ForeignType t) { fgnArg.type(t); }
};

class FgnVarArgSpec : public FgnArgSpec {
  FgnArg fgnArg;
protected:
  SNunit* result;
public:
  FgnVarArgSpec(SNunit* v, enum ForeignType ft, SNunit* r)
    : FgnArgSpec("fgnVarArg"), fgnArg(v, ft), result(r) {}
  ~FgnVarArgSpec() { delete &result; }
  virtual void print(ostream&);
  virtual void split();
  virtual bool isArgSpecTypeOf(FgnArgSpecType ast) {
    return (ast == FgnArgSpecTypeVar ? TRUE : FALSE);
  }

  virtual SNunit* Var() { return fgnArg.Var(); }
  virtual void Var(SNunit* v) { fgnArg.Var(v); }
  virtual enum ForeignType type() { return fgnArg.type(); }
  virtual void type(enum ForeignType t) { fgnArg.type(t); }
  SNunit* Result() { return result; }
  void Result(SNunit* v) { result = v; }
};

class FgnRetValSpec : public SNunit {
protected:
  FgnArg fgnArg;
public:
  FgnRetValSpec(SNunit* v, enum ForeignType ft)
    : SNunit("fgnRetVal"), fgnArg(v, ft) {}
  virtual void print(ostream&);
  virtual void split(int);
  SNunit* Var() { return fgnArg.Var(); }
  virtual void Var(SNunit* v) { fgnArg.Var(v); }
  enum ForeignType type() { return fgnArg.type(); }
  virtual void type(enum ForeignType t) { fgnArg.type(t); }
};

class SNfgncall : public SNunit {
  static numberedLabel newLabel;

protected:
  Name label;
  FgnLinkage* linkage;
  char* procname;
  FgnArgSpecList* argspecs;
  FgnRetValSpec* retvalspec;

  SNmethod* createTrueBranch();
  SNmethod* createFalseBranch();

public:
  SNfgncall(FgnLinkage* flp,
	    char* pn,
	    FgnArgSpecList* asp,
	    FgnRetValSpec* rvp)
    : SNunit("foreign call"), label(newLabel.next()) {
    linkage = flp;
    procname = pn;
    argspecs = asp;
    retvalspec = rvp;
  }
  ~SNfgncall() {
#if __GNUG__ == 2
    delete[] procname;
#else
    delete[strlen(procname) + 1] procname;
#endif
    delete argspecs;
    delete retvalspec;
  }

  FgnLinkage* Linkage() { return linkage; }
  void Linkage(FgnLinkage* flp) { linkage = flp; }

  enum FgnLinkType linkageSpec() { return linkage->Type(); }

  char* procName() { return procname; }
  void procName(char* pn) {
#if __GNUG__ == 2
    delete[] procname;
#else
    delete[strlen(procname) + 1] procname;
#endif
    procname = pn;
  }

  FgnArgSpecList* argSpecList() { return argspecs; }
  void argSpecList(FgnArgSpecList* asl) { argspecs = asl; }

  FgnRetValSpec* retValSpec() { return retvalspec; }
  void retValSpec(FgnRetValSpec* rvs) { retvalspec = rvs; }

  virtual void print(ostream&);
  virtual void split(int);
  virtual Rind encode(instList&); // disabled
  virtual void encodeAtGround(instList&);

  void transform(SNmethod*);

  virtual void putDeclarations(instList&);
};

declare(gList, SNfgncall);

class SNfgncallList : public gList(SNfgncall) {
};

class SNfgncallListItr : public gList_iterator(SNfgncall) {
public:
  SNfgncallListItr(SNfgncallList* l) : gList_iterator(SNfgncall)(l) {}
};

#endif SNfgnmtd_h
