/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <ctype.h>
#include <string.h>
#include <assert.h>
#include "intList.h"
#include "RegTable.h"
#include "SNand.h"
#include "SNbool.h"
#include "SNcond.h"
#include "SNclassof.h"
#include "SNerror.h"
#include "SNequal.h"
#include "SNfgnmtd.h"
#include "SNinlet.h"
#include "SNint.h"
#include "SNmessage.h"
#include "SNnew.h"
#include "SNplain.h"
#include "SNsend.h"
#include "SNsymbol.h"
#include "SNvolatile.h"
#include "errmsg.h"

#include "CDfgncall.h"
#include "PIfgndef.h"

numberedLabel SNfgncall::newLabel("fgn");
C_Linkage C_linkage;
CppLinkage Cpplinkage;

FgnLinkage* FgnLinkage::instance(FgnLinkType flt)
{
  switch (flt) {
  case FgnLinkTypeC:
    return &C_linkage;
  case FgnLinkTypeCpp:
    return &Cpplinkage;
  default:
    assert(FALSE);
  }
  // not reached; the following line is a dummy
  return 0;
}

char * FgnTypeName(enum ForeignType t)
{
  switch (t) {
  case FgnTypeInteger:
    return "integer";
  case FgnTypeDouble:
    return "double_float";
  case FgnTypeString:
    return "string";
  case FgnTypeForeign:
    return "foreign";
  default:
    assert(FALSE);
  }
  // not reached; the following line is a dummy
  return 0;
}

void FgnArgSpec::split(int n) { assert(FALSE); }

FgnValArgSpec* FgnArgSpec::asValSpec()
{
  if (isArgSpecTypeOf(FgnArgSpecTypeVal)) {
    return (FgnValArgSpec*)this;
  }
  else return 0;
}

FgnVarArgSpec* FgnArgSpec::asVarSpec()
{
  if (isArgSpecTypeOf(FgnArgSpecTypeVar)) {
    return (FgnVarArgSpec*)this;
  }
  else return 0;
}

intList* FgnArgSpecList::encodeArgs(instList& code)
{
  intList* argRinds = new intList;
  FgnArgSpecListItr itr(this);
  for (FgnArgSpec* asp = itr() ; asp ; asp = itr.next()) {
    Rind r = asp->Var()->encode(code);
    argRinds->add(r + 1);
  }
  return argRinds;
}

FgnValArgSpec* FgnArgSpecListItr::ValSpec()
{
  FgnArgSpec* asp = operator () ();
  while (asp) {
    FgnValArgSpec* valspec = asp->asValSpec();
    if (valspec) return valspec;
    asp = next();
  }
  return 0;
}

FgnValArgSpec* FgnArgSpecListItr::nextValSpec()
{
  FgnArgSpec* asp;
  while (asp = next()) {
    FgnValArgSpec* valspec = asp->asValSpec();
    if (valspec) return valspec;
  }
  return 0;
}

FgnVarArgSpec* FgnArgSpecListItr::VarSpec()
{
  FgnArgSpec* asp = operator () ();
  while (asp) {
    FgnVarArgSpec* varspec = asp->asVarSpec();
    if (varspec) return varspec;
    asp = next();
  }
  return 0;
}

FgnVarArgSpec* FgnArgSpecListItr::nextVarSpec()
{
  FgnArgSpec* asp;
  while (asp = next()) {
    FgnVarArgSpec* varspec = asp->asVarSpec();
    if (varspec) return varspec;
  }
  return 0;
}

void FgnArg::split() { var->split(1); }

void FgnValArgSpec::print(ostream& ost)
{
  ost << Var() << " : " << FgnTypeName(type());
}

void FgnValArgSpec::split() { fgnArg.split(); }

void FgnVarArgSpec::print(ostream& ost)
{
  ost << Var() << " : " << FgnTypeName(type()) << " result " << Result();
}

void FgnVarArgSpec::split() { fgnArg.split(); }

void FgnRetValSpec::print(ostream& ost)
{
  ost << Var() << " : " << FgnTypeName(type());
}

void FgnRetValSpec::split(int n)
{
  assert(FALSE);
}

SNmethod* SNfgncall::createTrueBranch()
{
  // create context
  SNstreamList* streams = new SNstreamList;

  // count arguments and return value in new context;
  FgnArgSpecListItr itr(argspecs);
  for (FgnArgSpec* asp = itr() ; asp ; asp = itr.next()) {
    SNplain* pp = (SNplain*)asp->Var();
    asp->Var(SNplain::create(pp->Name(), streams));
    delete pp;
    if (asp->isArgSpecTypeOf(FgnArgSpecTypeVar)) {
      FgnVarArgSpec* vap = asp->asVarSpec();
      SNinlet* ip = (SNinlet*)vap->Result();
      vap->Result(SNinlet::create(ip->Name(), streams));
      delete ip;
    }
  }
  if (retvalspec) {
    SNinlet* ip = (SNinlet*)retvalspec->Var();
    retvalspec->Var(SNinlet::create(ip->Name(), streams));
    delete ip;
  }

  // create method
  SNmessage* msgp = new SNmessage(new SNbool(TRUE), 0);
  msgp->setProtocol(SNcond::trueProtocol);
  SNmethod* mp = new SNmethod(*streams);
  mp->setSelector(msgp);
  mp->setDescend(M_DESCEND);

  // embed the foreign call as an action
  mp->get_actions().add(this);

  return mp;
}

SNmethod* SNfgncall::createFalseBranch()
{
  // :`false ->
  //	  classof (#debugio :print("Runtime error: Type mismatch ")
  //			    :print("at foreign procedure call.\n")) ? (
  //	  :debugio ->
  //	      1 :undefined_method_deliberately_used_to_abort.
  //	  ).

  // create method
  SNmessage* msgp = new SNmessage(new SNbool(TRUE), 0);
  msgp->setProtocol(SNcond::falseProtocol);
  SNmethod* mp = new SNmethod(*new SNstreamList);
  mp->setSelector(msgp);
  mp->setDescend(M_DESCEND);

  // create action to print error message
  SNname* debugio = new SNname("debugio");
  SNnew* newInstance = new SNnew(debugio);
  SNsymbol* print = new SNsymbol("print");
  SNmessage* printMessage = new SNmessage(print, 1);
  SNstring* theString = new SNstring("\nRuntime error: Type mismatch "
				 "at foreign procedure call.\n");
  (*printMessage)[0] = theString;
  Protocol* pp = new Protocol(printMessage);
  Protocol* ipp = pp->intern();
  printMessage->setProtocol(ipp == pp ? pp : (delete pp, ipp));
  SNsend* sending = new SNsend(newInstance, printMessage);

  // create volatile class definition to wait completion of printing
  SNclassof* classof = new SNclassof(sending);
  SNvolatile* vcp = new SNvolatile(classof);

  // create method to be invoked upon completion of printing
  SNmethod* syncMethod = new SNmethod(*new SNstreamList);
  SNsymbol* debugioSymbol = new SNsymbol("debugio");
  SNmessage* debugioMessage = new SNmessage(debugioSymbol, 0);
  pp = new Protocol(debugioMessage);
  ipp = pp->intern();
  debugioMessage->setProtocol(ipp == pp ? pp : (delete pp, ipp));
  syncMethod->setSelector(debugioMessage);
  syncMethod->setDescend(M_DESCEND);

  // create action to cause runtime error
  SNint* one = new SNint(1);
  SNsymbol* runtimeError = new SNsymbol("undefined_method_deliberately_"
					"used_to_abort");
  SNmessage* runtimeErrorMessage = new SNmessage(runtimeError, 0);
  pp = new Protocol(runtimeErrorMessage);
  ipp = pp->intern();
  runtimeErrorMessage->setProtocol(ipp == pp ? pp : (delete pp, ipp));
  SNsend* sending2 = new SNsend(one, runtimeErrorMessage);
  syncMethod->get_actions().add(sending2);

  // put all together into one method
  vcp->get_methods().add(syncMethod);
  mp->get_volatiles().add(vcp);
  mp->get_actions().add(vcp);
  return mp;
}

void SNfgncall::transform(SNmethod* mp)
{
  // if no arguments, the proc can be called immediately
  if (argspecs == 0 || argspecs->length() == 0) {
    // embed the foreign call as an action
    mp->get_actions().add(this);
    return;
  }

  // get old context;
  SNstreamList* streams = &(mp->get_streams());

  // uncount arguments and return value in the old context;
  FgnArgSpecListItr itr(argspecs);
  for (FgnArgSpec* asp = itr() ; asp ; asp = itr.next()) {
    SNplain* pp = (SNplain*)asp->Var();
    (streams->find(pp->Name()))->uncount(ORD_OUTLET);
    if (asp->isArgSpecTypeOf(FgnArgSpecTypeVar)) {
      FgnVarArgSpec* vap = asp->asVarSpec();
      SNinlet* ip = (SNinlet*)vap->Result();
      (streams->find(ip->Name()))->uncount(ORD_INLET);
    }
  }
  if (retvalspec) {
    SNinlet* ip = (SNinlet*)retvalspec->Var();
    (streams->find(ip->Name()))->uncount(ORD_INLET);
  }

  // create volatile class definition
  /// form interface expr for volatile object
  itr.reset();
  asp = itr();
  char* varName = ((SNplain*)asp->Var())->Name();
  SNplain* pp = SNplain::create(varName, streams);
  SNunit* up1 = new SNequal(new SNclassof(pp),
			    new SNsymbol(FgnTypeName(asp->type())));
  for (asp = itr.next() ; asp ; asp = itr.next()) {
    varName = ((SNplain*)asp->Var())->Name();
    pp = SNplain::create(varName, streams);
    SNunit* up2 = new SNequal(new SNclassof(pp),
			      new SNsymbol(FgnTypeName(asp->type())));
    up1 = new SNand(up1, up2);
  }

  /// create methods;
  SNvolatile* vp = new SNvolatile(up1);
  vp->get_methods().add(createTrueBranch());
  vp->get_methods().add(createFalseBranch());

  /// attach volatile class def to foreign method
  mp->get_volatiles().add(vp);
  mp->get_actions().add(vp);
}

void SNfgncall::putDeclarations(instList& decls)
{
  Name name = linkage->TypeName();
  decls.add(new PIfgndef(name, label));
  name = linkage->linkName(procName());
  decls.add(new PIname(name));
  FgnArgSpecListItr itr(argspecs);
  for (FgnArgSpec* asp = itr() ; asp ; asp = itr.next()) {
    decls.add(new PIarg(FgnTypeName(asp->type())));
  }
  if (retvalspec) decls.add(new PIreturn(FgnTypeName(retvalspec->type())));
  decls.add(new PIendfgn(label));
}

void SNfgncall::print(ostream& ost)
{
  Name n = linkage->TypeName();
  ost << "< foreign call " << n << "\n";
  ost << "call " << procName() << "\n";
  FgnArgSpecListItr itr(argSpecList());
  FgnArgSpec* asp = itr();
  if (asp != 0) {
    ost << "arg " << asp;
    for (asp = itr.next() ; asp ; asp = itr.next()) {
      ost << " ;\n     " << asp;
    }
    ost << "\n";
  }
  FgnRetValSpec* retvalspec = retValSpec();
  if (retvalspec) {
    ost << "return " << retvalspec << "\n";
  }
  ost << ">";
}

void SNfgncall::split(int n)
{
  // There is no need of splitting for `retvalspec',
  // since it is always an inlet variable.
  FgnArgSpecListItr itr(argSpecList());
  for (FgnArgSpec* asp = itr() ; asp ; asp = itr.next()) {
    asp->split();
  }
}

Rind SNfgncall::encode(instList& ) { assert(FALSE); return -1; }

void SNfgncall::encodeAtGround(instList& code)
{
  intList* argRinds = argSpecList()->encodeArgs(code);
  Rind Rretval = regTable.newReg();
  regTable.set(Rretval, 1);
  code.add(new CDfgncall(Rretval, label, argRinds));
  FgnArgSpecListItr itr(argSpecList());
  for (FgnVarArgSpec* vsp = itr.VarSpec() ; vsp ; vsp = itr.nextVarSpec()) {
    SNunit* pp = vsp->Var();
    SNunit* ip = vsp->Result();
    autoClose(ip->connectTo(pp->encode(code), code), code);
  }
  if (retValSpec()) {
    autoClose(retValSpec()->Var()->connectTo(Rretval, code), code);
  }
}

Name C_Linkage::linkName(Name& pn)
{
  char* string = (char*)pn;
  char* p = string;
  if (!isalpha(*p) && *p != '_') {
  error:
    sprintf(ErrorMessageBuffer,
	    "can't recognize '%s' as a C function name",
	    string);
    SNerror(ErrorMessageBuffer, LineNumber());
  }
  p++;
  while (isalnum(*p) || *p == '_') p++;
  int linknamelen = p - string;
  if (*p != '(') goto error;
  while (*p && *p != ')') p++;
  if (!*p) goto error;

  int funcnamelen = strlen(string) + 1;
  char* q = new char[funcnamelen];
  strncpy(q, string, linknamelen);
  q[linknamelen] = '\0';
  Name linkname(q);
#if __GNUG__ == 2
  delete[] q;
#else
  delete[funcnamelen] q;
#endif
  return linkname;
}

Name CppLinkage::linkName(Name& pn)
{
  // Sorry, not supported yet.
  assert(FALSE);
  // not reached; the following line is a dummy.
  return pn;
}
