/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNexport_h
#define SNexport_h 1

// SNexport : ܥ饿륯饹ˤѿ͢Фɽ

#include <stream.h>
#include "RegTable.h"
#include "SNunit.h"
#include "SNunitArray.h"

class instList;
class SNmethod;
class SNexport;
class SNimport;

class SNexportedVar {
friend class SNexport;
  friend void SNmethod::export(SNexport*, SNimport*, instList&);

  SNunit* node;
  Rind regno;
  RegTableEntry* reg;

  SNexportedVar() { node = 0; regno = -1; reg = 0; }
  void assignRegno(instList&);
  void saveReg();
  void restoreReg();
  void autoClose(instList&);
};

declare(gArray, SNexportedVar);

class SNexport {
friend class SNexportItr;
  friend void SNmethod::export(SNexport*, SNimport*, instList&);

  gArray(SNexportedVar) varTable;
public:
  SNexport(int l) : varTable(l) {}
  void setVar(int i, SNunit* vp) {
    varTable[i] = new SNexportedVar;
    varTable[i]->node = vp;
  }
  SNunit*& operator[](int i) { return varTable[i]->node; }
  int length() const { return varTable.length(); }
  void split();
  void assignRegno(instList&);
  void saveRegs();
  void restoreRegs();
  void autoClose(instList&);
};

struct SNexportItr : gArrayItr(SNexportedVar) {
  SNexportItr(SNexport& ex) : (ex.varTable) {}
};

#endif SNexport_h
