/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include "SNexport.h"
#include "RegTable.h"
#include "CDconnect.h"

void SNexport::split()
{
  for (int i = 0 ; i < length() ; i++) {
    varTable[i]->node->split(1);
  }
}

void SNexportedVar::saveReg()
{
  assert(regno >= 0);
  reg = regTable.save(regno);
  regTable.setBottom(regno);
}

void SNexport::saveRegs()
{
  for (int i = 0 ; i < length() ; i++) {
    varTable[i]->saveReg();
  }
}

void SNexportedVar::restoreReg()
{
  assert(regno >= 0);
  regTable.restore(regno, reg);
}

void SNexport::restoreRegs()
{
  for (int i = 0 ; i < length() ; i++) {
    varTable[i]->restoreReg();
  }
}

void SNexportedVar::autoClose(instList& code)
// δؿϡSNexportedVar::regnoͤassignRegno()ˤä
// ꤷǤʤа˼¹ԤǤʤ
{
  assert(regno >= 0);
  ::autoClose(regno, code);
}

void SNexport::autoClose(instList& code)
{
  for (int i = 0 ; i < length() ; i++) {
    varTable[i]->autoClose(code);
  }
}

void SNexportedVar::assignRegno(instList& code)
{
  regno = node->regno();
  if (regno < 0) regno = node->encode(code);
  assert(regno >= 0);
}

void SNexport::assignRegno(instList& code)
{
  for (int i = 0 ; i < length() ; i++) {
    varTable[i]->assignRegno(code);
  }
}
