/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stdlib.h>
#include <stream.h>
#include "SNerror.h"

Name currentClassName = unsetClassName;
Name currentFileName = unsetFileName;
int numberOfError = 0;

void SNwarning(char* msg, int ln)
{
  cerr << currentFileName << ":" << (ln ? dec(ln) : "?") << ":";
  cerr << msg << "\n";
}

void SNerror(char* msg, int ln = 0)
{
  SNwarning(msg, ln);
  numberOfError++;
  if (numberOfError > MaxNumberOfError) {
    cerr << currentFileName << ":" << (ln ? dec(ln) : "?") << ":";
    cerr << "too many errors.\n";
    exit(1);
  }
}
