/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNelto_h
#define SNelto_h 1

#include "SNbinop.h"
#include "CDelto.h"

class SNelto : public SNbinop {
  virtual void print(ostream& ost) {
    // X[I]
    ost << arg1 << "[" << arg2 << "]";
  }
  virtual char* opName() { return "[]"; }

public:
  SNelto(SNunit* a, SNunit* b) : SNbinop("elto", a, b) {};
  void encodeMessageSending(Rind r1, Rind r2, Rind r3, instList& code) {
    code.add(new CDelto(r1, r2, r3));
  }
};

#endif SNelto_h
