/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNelti.h,v 1.2 1991/06/26 00:40:56 konishi Exp konishi $
 *
 */

#ifndef SNelti_h
#define SNelti_h 1

#include "SNunit.h"
#include "CDelti.h"

struct SNelti : SNunit {
  SNunit* arg1;			// array
  SNunit* arg2;			// index
  SNunit* arg3;			// value refered
public:
  SNelti(SNunit* a, SNunit* b, SNunit* c)
    : SNunit("elti"), arg1(a), arg2(b), arg3(c) {};
  void print(ostream& ost) {
    // X :elt(I, Y)
    ost << arg1 << ":elt(" << "arg2" << ", " << arg3 << ")";
  }
  void encodeMessageSending(Rind r1, Rind r2, Rind r3, instList& code) {
    code.add(new CDelti(r1, r2, r3));
  }
};

#endif SNelti_h
