/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNdouble_h
#define SNdouble_h 1

#include <builtin.h>
#include "SNliteral.h"
#include "CDcdouble.h"		// Create double

class SNdouble : public SNliteral {
  double value;

  virtual void encodeCreation(Rind r, instList& code) {
    code.add(new CDcreate_dfloat(r, value));
  }

public:
  SNdouble(double& d) : SNliteral("double") { value = d; }

  void print(ostream& ost) { ost << "0d" << dtoa(value, 'g', 0, 16); }
};

#endif SNdouble_h
