/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include "SNdefmsg.h"
#include "defPcol.h"

SNdefmsg::SNdefmsg(SNunit* inlet) : SNmessage((SNunit*)0, 1)
{
  onlyArg() = inlet;
  assert(defaultProtocol::uniqueInstance != 0);
  pcol = defaultProtocol::uniqueInstance;
}

void SNdefmsg::encodeAtGround(instList& code, Rind rTop)
{
  assert(onlyArg()->inletExp());
  autoClose(onlyArg()->connectTo(rTop, code), code);
}
