/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNconnect_h
#define SNconnect_h 1

#include "SNunit.h"

class SNconnect : public SNunit {
  SNunit* inlet;
  SNunit* outlet;
public:
  SNconnect(SNunit* i, SNunit* o)
    : SNunit("connect") { inlet = i; outlet = o; }
  void print(ostream& ost) { ost << outlet << " = " << inlet; }
  void split(int n) { outlet->split(n+1); inlet->split(0); }
  Rind encode(instList& code) { return outlet->connected(inlet, code); }
				// Send a message to an argument
				// to tell slot renewal from connection
  void encodeAtGround(instList& code) {
    outlet->connectedAtGround(inlet, code);
  }				// To handle 'Set inlet slot.'
};

#endif SNconnect_h
