/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNclslit_h
#define SNclslit_h 1

#include <string.h>
#include "SNliteral.h"
#include "CDcatom.h"		// Create atom

class SNclsliteral : public SNliteral {
  char* name;

  virtual void encodeCreation(Rind r, instList& code) {
    code.add(new CDcreate_atom(r, name));
  }

public:

  SNclsliteral::SNclsliteral(char* nm) : SNliteral("clslit") {
    name = new char[strlen(nm) + 1];
    strcpy(name, nm);
  }
  ~SNclsliteral() { delete name; }
  void print(ostream& ost) { ost << "##" << name; };
};

#endif SNclslit_h
