/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNclass_h
#define SNclass_h 1

#include <assert.h>
#include "SNname.h"
#include "SNunit.h"
#include "SNnameList.h"
#include "SNmethodList.h"
#include "Rind.h"

class instList;
class SNfgncallList;

class SNclass : virtual public SNunit {
friend class SNtree;
protected:
  SNname *name;
  SNnameList supers;
  SNnameList islots;
  SNnameList oslots;
  SNmethodList methods;
  SNfgncallList* fgncalls;

  void printNames(char*, SNnameList*, ostream&);
  void printMethods(SNmethodList*, ostream&, char* = ".");
public:
  SNclass(SNname* nmp) : SNunit("class") {
    name = nmp;
    fgncalls = 0;
  }
  ~SNclass();
  const SNname& get_name() { return *name; }
  SNnameList& get_supers() { return supers; }
  SNnameList& get_islots() { return islots; }
  SNnameList& get_oslots() { return oslots; }
  SNmethodList& get_methods() { return methods; }
  SNfgncallList* fgnCalls() { return fgncalls; }
  void fgnCalls(SNfgncallList* fcl) { fgncalls = fcl; }
  void print(ostream&);
  void print_rc();
  void split();
  virtual void split(int) { assert(FALSE); }
  virtual void printProtocols();
  virtual void printSelectorLengths() {}
  virtual void checkSelectorLengths() {}
  virtual int maxSelectorLength() { return 0; }
//  virtual void markSink() {}
//  void bindInletAndTopOutlet();

  void encodeAndPrint(ostream&);
  void markUnusedVars();
};

#endif SNclass_h
