/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNerror.h"
#include "SNclass.h"
#include "gList.h"
#include "inst.h"
#include "SNname.h"
#include "SNmethod.h"
#include "SNfgnmtd.h"
#include "Protocol.h"
#include "Classref.h"
#include "PIcomment.h"
#include "PIclass.h"
#include "PIclassref.h"
#include "PIpid.h"
#include "PIsuper.h"
#include "PIinlet.h"
#include "PIoutlet.h"
#include "PImethod.h"
#include "PIend.h"
#include "SNtree.h"

class instList;

SNclass::~SNclass()
{
  delete name;
  delete fgncalls;
}

void SNclass::printNames(char* hdr, SNnameList* names, ostream& ost)
{
  gList_iterator(SNname) nameIt(names);
  SNname* namep = nameIt();
  if (namep) {
    ost << "\t" << hdr << " " << *namep;
    while (namep = nameIt.next()) {
      ost << ", " << *namep;
    }
    ost << ".\n";
  }
}

void SNclass::printMethods(SNmethodList* methods,
			 ostream& ost,
			 char* delimiter)
{
  gList_iterator(SNmethod) methodIt(methods);
  SNmethod* methodp = methodIt();
  if (methodp) {
    methodp->print(ost);
    while (methodp = methodIt.next()) {
      ost << delimiter << "\n";
      methodp->print(ost);
    }
  }
}

void SNclass::print(ostream& ost)
{
  ost << "class " << *name << ".\n";
  printNames("super", &supers, ost);
  printNames("in", &islots, ost);
  printNames("out", &oslots, ost);
  printMethods(&methods, ost, ".");
  if (methods.length() > 0) ost << ".\n";
  ost << "end.\n";
}

void SNclass::print_rc()
{
  gList_iterator(SNmethod) methodIt(&methods);
  for (SNmethod* methodp = methodIt() ; methodp ;
       methodp = methodIt.next()) {
    methodp->print_rc();
  }
}

void SNclass::split()
{
  gList_iterator(SNmethod) mtds(&methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    mp->split();
  }
}

void SNclass::printProtocols()
{
  gList_iterator(SNmethod) mtds(&methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    cout << "'";
    mp->printProtocol();
    cout << "'\n";
  }
}

void SNclass::encodeAndPrint(ostream& ost)
{
  SNtree::currentClass = this;

  instList header;

  header.add(new PIcomment(""));
  header.add(new PIclass(*name));
  instList code;
  gList_iterator(SNmethod) mtds(&methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    mp->putPseudoInst(code);
    mp->putEntranceLabel(0, code);
    mp->encode(code);
  }
  code.add(new PIend(*name));
  classrefTable->remove(*name); // Υ饹ȤФ .classref 
  classrefTable->putPIclassrefs(header);
  classrefTable->clear();
  protocolTable->putPIpids(header);
  protocolTable->clear();
  gList_iterator(SNname) scit(&supers);
  for (SNname* sp = scit() ; sp ; sp = scit.next()) {
    header.add(new PIsuper(*sp));
  }
  gList_iterator(SNname) isit(&islots);
  for (SNname* ip = isit() ; ip ; ip = isit.next()) {
    header.add(new PIinlet(*ip));
  }
  gList_iterator(SNname) osit(&oslots);
  for (SNname* op = osit() ; op ; op = osit.next()) {
    header.add(new PIoutlet(*op));
  }

  // put foreign call declarations
  SNfgncallListItr fclItr(fgnCalls());
  for (SNfgncall* fcp = fclItr() ; fcp ; fcp = fclItr.next()) {
    fcp->putDeclarations(header);
  }

  header.print(ost);
  code.print(ost);
}

void SNclass::markUnusedVars()
{
  SNmethodListItr methodIt(methods);
  for (SNmethod* mp = methodIt() ; mp ; mp = methodIt.next()) {
    mp->markUnusedVars();
  }
}
