/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNcdri.h,v 1.3 1991/06/26 00:40:56 konishi Exp konishi $
 *
 */

#ifndef SNcdri_h
#define SNcdri_h 1

#include "SNunit.h"
#include "CDcdri.h"

class SNcdri : public SNunit {
  SNunit* arg1;			// List
  SNunit* arg2;			// value

public:
  SNcdri(SNunit* a, SNunit* b) : SNunit("cdri"), arg1(a), arg2(b) {};
  void print(ostream& ost) {
    // X :cdr(Y)
    ost << arg1 << ":cdr(" << arg2 << ")";
  }
  void encodeMessageSending(Rind r1, Rind r2, instList& code) {
    code.add(new CDcdri(r1, r2));
  }
  void split(int n) { arg1->split(n); arg2->split(1); }
};

#endif SNcdri_h
