/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNcari.h,v 1.3 1991/06/26 00:40:56 konishi Exp konishi $
 *
 */

#ifndef SNcari_h
#define SNcari_h 1

#include "SNunit.h"
#include "CDcari.h"

class SNcari : public SNunit {
  SNunit* arg1;			// List
  SNunit* arg2;			// value

public:
  SNcari(SNunit* a, SNunit* b) : ("cari"), arg1(a), arg2(b) {};
  void print(ostream& ost) {
    // X :car(Y)
    ost << arg1 << ":car(" << arg2 << ")";
  }
  void encodeMessageSending(Rind r1, Rind r2, instList& code) {
    code.add(new CDcari(r1, r2));
  }
  void split(int n) { arg1->split(n); arg2->split(1); }
};

#endif SNcari_h
