/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNbool_h
#define SNbool_h 1

#include "SNliteral.h"
#include "CDcbool.h"		// Create bool

class SNbool : public SNliteral {
  int istrue;

  virtual void encodeCreation(Rind r, instList& code) {
    code.add(new CDcreate_bool(r, istrue));
  }

public:
  SNbool(int b) : SNliteral("bool") { istrue = (b ? (1 == 1) : (1 == 0)); }

  void print(ostream& ost) { ost << (istrue ? "`true" : "`false"); }
};

#endif SNbool_h
