/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNbnkstr
#define SNbnkstr 1

#include "SNunit.h"

class SNblankString : public SNunit {
  int splitCount;

protected:
  SNunit* len;

public:
  SNblankString(SNunit* l) : SNunit("vector"), len(l), splitCount(0) {}
  void print(ostream& ost) {
    ost << "#string(" << len << ")";
  }
  void split(int n) { splitCount = n; len->split(1); }
  Rind encode(instList&);
};

#endif SNbnkstr


