/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNbnkstr.h"
#include "RegTable.h"
#include "CDcbnkstr.h"
#include "CDcint.h"
#include "CDsplit_n.h"

// create_string3 Rresult, Rsize, Rfill;

Rind SNblankString::encode(instList& code)
{
  Rind Rstr = regTable.newReg();
  regTable.set(Rstr, 1, OnOff(splitCount < 1));
  Rind Rlen = len->encode(code);
  Rind Rfill = regTable.newReg();
  regTable.set(Rfill, 1);
  code.add(new CDcreate_integer(Rfill, 0));
  code.add(new CDcreate_blank_string(Rstr, Rlen, Rfill));
  regTable.decrement(Rlen);
  regTable.decrement(Rfill);
  if (splitCount > 1) {
    code.add(new CDsplit_n(Rstr, splitCount - 1));
  }
  return Rstr;
}
