/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNbinop_h
#define SNbinop_h 1

#include "SNunit.h"
#include "SNbinarg.h"

class SNbinop : public SNunit, public SNbinarg {
  // from SNunit
  virtual void print(ostream& ost) { SNbinarg::print(ost); }
  virtual void split(int n) { SNbinarg::split(n); }
  virtual Rind encode(instList& code) { return SNbinarg::encode(code); }
  // from SNbinarg
  virtual char* _opName() { return opName(); }
  virtual void _encodeMessageSending(Rind r1, Rind r2,
				     Rind r, instList& code) {
    encodeMessageSending(r1, r2, r, code);
  }
  // its own
  virtual char* opName() = 0;
  virtual void encodeMessageSending(Rind, Rind, Rind, instList&) = 0;

public:
  SNbinop(char* nm, SNunit* a1, SNunit* a2) : SNunit(nm), SNbinarg(a1, a2) {}
};

#endif SNbinop_h
