/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNbincond_h
#define SNbincond_h 1

#include "SNbinarg.h"
#include "SNcond.h"
#include "Protocol.h"

class NameList;
class SNvolatile;

class SNbincond : public SNcond, public SNbinarg {
  // from SNunit inherited by SNcond
  virtual void print(ostream& ost) { SNbinarg::print(ost); }
  virtual void split(int n) { SNbinarg::split(n); }
  virtual Rind encode(instList& code) { return SNbinarg::encode(code); }
  // from SNbinarg
  virtual char* _opName() { return opName(); }
  virtual void _encodeMessageSending(Rind r1, Rind r2,
				     Rind r, instList& code) {
    encodeMessageSending(r1, r2, r, code);
  }
  // its own
  virtual Rind encodeAsInterface(char*, char*, instList&);
  virtual char* opName() = 0;
  virtual void addDirectJump(Rind, Rind, char*, char*, instList&) = 0;
  virtual void encodeMessageSending(Rind, Rind, Rind, instList&) = 0;

public:
  SNbincond(char* nm, SNunit* a1, SNunit* a2)
    : SNcond(nm), SNbinarg(a1, a2) {}
};

#endif SNbincond_h
