/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNbinarg_h
#define SNbinarg_h 1

#include "SNunit.h"

class SNbinarg {
protected:
  SNunit* arg1;
  SNunit* arg2;
  int splitCount;

  Rind encodeOperation(Rind, Rind, instList&);
  void print(ostream& ost) {
    ost << arg1 << " " << _opName() << " " << arg2;
  }
  void split(int n) { arg1->split(1); arg2->split(1); splitCount = n; }
  Rind encode(instList&);
  virtual char* _opName() = 0;
  virtual void _encodeMessageSending(Rind, Rind, Rind, instList&) = 0;

public:
  SNbinarg(SNunit* a1, SNunit* a2) : arg1(a1), arg2(a2), splitCount(0) {}
};

#endif SNbinarg_h
