/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "OnOff.h"
#include "RegTable.h"
#include "SNbinarg.h"
#include "CDsplit_n.h"
#include "CDclose.h"

Rind SNbinarg::encode(instList& code)
{
  Rind r1 = arg1->encode(code);
  Rind r2 = arg2->encode(code);
  return encodeOperation(r1, r2, code);
}

Rind SNbinarg::encodeOperation(Rind r1, Rind r2, instList& code)
{
  Rind r = regTable.newReg();
  regTable.set(r, 1, OnOff(splitCount < 1));
  _encodeMessageSending(r1, r2, r, code);
  // Jun25 ϽФͻҤ򸫤롣
  // // Jun17 Ū˥ѥ餬closeФȤˤ롣
  // code.add(new CDclose(r1)); // binop̿ǹԤ٤close
  regTable.decrement(r1);
  regTable.decrement(r2);
  if (splitCount > 1) {
    code.add(new CDsplit_n(r, splitCount - 1));
  }
  return r;
}
