/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNanonin.h"
#include "RegTable.h"
#include "CDclose.h"
#include "CDcmj.h"

SNanonin* SNanonin::onlyInstance = 0;

Rind SNanonin::encode(instList& code)
{
  Rind r = regTable.newReg();
  regTable.set(r, 1, ON);
  code.add(new CDcreate_mjoint(r));
  return r;
}

Rind SNanonin::connectTo(Rind outlet, instList& code)
{
  regTable.add(outlet, 0, ON);
  return outlet;
}

SNanonin* SNanonin::instance()
{
  if (onlyInstance == 0) onlyInstance = new SNanonin();
  return onlyInstance;
}
