/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNand_h
#define SNand_h 1

#include "SNbinop.h"
#include "CDand.h"

struct SNand : SNbinop {
  SNand(SNunit* a1, SNunit* a2) : SNbinop("and", a1, a2) {}
  char* opName() { return "and"; }

  void encodeMessageSending(Rind r1, Rind r2, Rind r3, instList& code) {
    code.add(new CDand(r1, r2, r3));
  }
};

#endif SNand_h
