/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef Protocol_h
#define Protocol_h 1

#include <bool.h>
#include "Name.h"
#include "SNmessage.h"
#include "gArray.h"

class ostream;
class instList;
class Name;
class ProtocolTable;

class Protocol {
private:
  friend class ProtocolTable;

  char* func;
  int len;
  char* modeArray;

  int hash();

public:
  static Protocol* intern(char*, int);

  Protocol(SNmessage*);
  Protocol(char* func, int arity);
  ~Protocol();

  void flip();
  Protocol* intern();

//  operator char*();
  Name funcname() { return Name(func); }
  Name string();
  Name label(char*);
  int length() { return len; }

  virtual void addPImethod(instList&);
  virtual void addPIpid(instList&);

  virtual void print(ostream&);
  virtual void putEntranceLabel(char*, instList&);
  bool equal(Protocol* pp);
};

inline ostream& operator<<(ostream& ost, Protocol* pp)
{
  pp->print(ost); return ost;
}

inline bool operator==(Protocol& a, Protocol& b)
{
  return &a == &b;
}

declare(gArray,Protocol);

extern int protocolTableSize;
struct ProtocolTable : gArray(Protocol) {
  ProtocolTable(int);
  void clear();
  void putPIpids(instList&);
  Protocol*& elt(int i) {
    return gArray(Protocol)::operator [] (i);
  }
};

extern ProtocolTable* protocolTable;

#endif Protocol_h
