/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stdlib.h>
#include <bool.h>
#include "SNerror.h"
#include "Protocol.h"
#include "PImethod.h"
#include "PIpid.h"
#include "nameStream.h"
#include "CDlabel.h"
#include "closePcol.h"

int  protocolTableSize = 1024;
ProtocolTable* protocolTable;

ProtocolTable::ProtocolTable(int n) : (n)
{
  for (int i = 0 ; i < length() ; i++) {
    (*this)[i] = 0;
  }
}

void ProtocolTable::clear()
{
  for (int i = 0 ; i < length() ; i++) {
    Protocol* pp = (*this)[i];
    if (pp) delete pp;
    (*this)[i] = 0;
  }
}

void ProtocolTable::putPIpids(instList& code)
{
  for (int i = 0 ; i < length() ; i++) {
    Protocol* pp = (*this)[i];
    if (pp) pp->addPIpid(code);
  }
}

int Protocol::hash()
{
#ifdef IOSTREAM_2_0
  ostrstream nameStream(namebuffer, bufsize);
#else
  ostream nameStream(bufsize, namebuffer);
#endif
  nameStream << this;
  nameStream.put('\0');
  int namelen = strlen(namebuffer);
  int h = len;
  for (int i = 0 ; i < namelen ; i++) {
    h += namebuffer[i];
  }
  while (h > 0x7f) {
    h = (h & 0x7f) + (h >> 7);
  }
  return h % protocolTableSize;
}

Protocol* Protocol::intern()
{
  // '::' Ф̰ʤ
  if (len == 0 && strcmp(func, "::") == 0) {
    if (!closeProtocol::uniqueInstance) {
      closeProtocol::uniqueInstance = new closeProtocol();
    }
    return closeProtocol::uniqueInstance;
  }
  // '::' Ф̰ʤޤǡ
  int h = hash();
  for (int i = h ; i < protocolTable->length() ; i++) {
    Protocol* pp = protocolTable->elt(i);
    if (pp == 0) {
      protocolTable->elt(i) = this;
      return this;
    }
    else if (this->equal(pp)) {
      return pp;
    }
  }
  for (i = 0 ; i < h ; i++) {
    Protocol* pp = protocolTable->elt(i);
    if (pp == 0) {
      protocolTable->elt(i) = this;
      return this;
    }
    else if (this->equal(pp)) {
      return pp;
    }
  }
  SNwarning("no more protocol table entry left, bye");
  exit(1);
  // not reached; the following line is a dummy
  return 0;
}

Protocol* Protocol::intern(char* func, int arity)
{
  Protocol* pp = new Protocol(func, arity);
  Protocol* ipp = pp->intern();
  if (ipp != pp) delete pp;
  return ipp;
}

Protocol::Protocol(SNmessage* msg)
{
  if (msg->func) {
#ifdef IOSTREAM_2_0
    ostrstream nameStream(namebuffer, bufsize);
#else
    ostream nameStream(bufsize, namebuffer);
#endif
    nameStream << msg->func;
    nameStream.put('\0');
    func = fresh_string(namebuffer);
  }
  else func = fresh_string("_NO_NAME_");
  len = msg->arity;
  if (len > 0) {
    modeArray = new char[len + 1];
    for (int i = 0 ; i < len ; i++) {
      modeArray[i] = msg->args[i]->inletExp();
    }
    modeArray[len] = '\0';
  }
  else modeArray = 0;
}

Protocol::Protocol(char* f, int a) : func(fresh_string(f)), len(a)
{
  modeArray = new char[len + 1];
  for (int i = 0 ; i < len ; i++) modeArray[i] = 0;
  modeArray[len] = '\0';
}

Protocol::~Protocol()
{
#if __GNUG__ == 2
  delete[] func;
  delete[] modeArray;
#else
  delete[strlen(func) + 1] func;
  delete[len] modeArray;
#endif
}

void Protocol::flip()
{
  for (int i = 0 ; i < len ; i++) {
    modeArray[i] = !modeArray[i];
  }
}

Name Protocol::string()
{
#ifdef IOSTREAM_2_0
    ostrstream nameStream(namebuffer, bufsize);
#else
  ostream nameStream(bufsize, namebuffer);
#endif
  nameStream << func;
  if (len > 0) {
    nameStream << "/";
    for (int i = 0 ; i < len ; i++) {
      nameStream << (modeArray[i] ? "-" : "+");
    }
  }
  nameStream.put('\0');
  return Name(namebuffer);
}

Name Protocol::label(char* ext)
{
#ifdef IOSTREAM_2_0
    ostrstream nameStream(namebuffer, bufsize);
#else
  ostream nameStream(bufsize, namebuffer);
#endif
  Name s = string();
  nameStream << s << "_" << ext;
  nameStream.put('\0');
  return Name(namebuffer);
}

void Protocol::print(ostream& ost)
{
  ost << func;
  if (len > 0) {
    ost << "/";
    for (int i = 0 ; i < len ; i++) {
      ost << (modeArray[i] ? "-" : "+");
    }
  }
}

void Protocol::addPImethod(instList& code)
{
  Name pname = string();
  long mode = 0;
  for (int i = 0 ; i < len ; i++) {
    if (modeArray[i] == 0) mode |= (1L << i);
  }
  code.add(new PImethod(pname, func, len, mode));
}

void Protocol::addPIpid(instList& code)
{
  Name pname = string();
  char* mode = new char[len + 1];
  for (int i = 0 ; i < len ; i++) {
    mode[i] = modeArray[i] ? '-' : '+';
  }
  mode[len] = '\0';
  code.add(new PIpid(pname, func, len, mode));
#if __GNUG__ == 2
  delete[] mode;
#else
  delete[len + 1] mode;
#endif
}

void Protocol::putEntranceLabel(char* vname, instList& code)
{
#ifdef IOSTREAM_2_0
    ostrstream nameStream(namebuffer, bufsize);
#else
  ostream nameStream(bufsize, namebuffer);
#endif
  Name pcolname = string();
  nameStream << pcolname;
  if (vname) nameStream << "_" << vname;
  nameStream.put('\0');
  code.add(new CDlabel(namebuffer));
}

bool Protocol::equal(Protocol* pp)
{
  if (len != pp->len) return FALSE;
  if (strcmp(func, pp->func) != 0) return FALSE;
  for (int i = len - 1 ; i >= 0 ; i--) {
    if (modeArray[i] != pp->modeArray[i]) return FALSE;
  }
  return TRUE;
}
