/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef MovTable_h
#define MovTable_h 1

#include "Rind.h"
#include "RegTable.h"

class instList;
class intList;

class MovTable {
  Rind dest[RegTableSize];
  Rind maxUsed;
  Rind minFree;

public:
  MovTable(RegTable&);
  int used(Rind r) { return dest[r] == r; }
  void findMinFree();
  void fold(int);
  Rind to(Rind r) { return dest[r]; }
  int moved(Rind r) { return dest[r] != r; }
  void encodeUnfolding(instList&);
  intList* argList();
  void encodeStoringArgs(int, instList&);
  Rind maxUsedRind() { return maxUsed; }
  Rind minFreeRind() { return minFree; }
};

#endif MovTable_h
