/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "intList.h"
#include "MovTable.h"
#include "CDmove.h"
#include "CDgetoutlet.h"
#include "CDset_arg.h"

MovTable::MovTable(RegTable& rt) : minFree(0), maxUsed(0)
{
  for (int i = 0 ; i < RegTableSize ; i++) {
    if (rt.ents[i].count != 0) {
      maxUsed = dest[i] = i;
    }
    else dest[i] = -1;
  }
}

void MovTable::findMinFree()
{
  for (int i = minFree ; i < RegTableSize ; i++) {
    if (dest[i] < 0) {
      minFree = i;
      return;
    }
  }
  minFree = RegTableSize;
}

void MovTable::fold(int maxsellen)
{
  findMinFree();
  for (int i = maxUsed + maxsellen ; i > maxUsed ; i--) {
    if (minFree > i) {
      maxUsed = i;
      return;
    }
    dest[minFree] = i;
    findMinFree();
  }
  for (; i >= 0 ; i--) {
    if (used(i)) {
      if (minFree >= i) {
	maxUsed = i;
	return;
      }
      dest[minFree] = i; dest[i] = -1;
      findMinFree();
    }
  }
}

void MovTable::encodeUnfolding(instList& code)
{
  for (int i = 0 ; i < minFree ; i++) {
    if (moved(i)) {
      code.add(new CDmove(i, dest[i]));
    }
  }
}

intList* MovTable::argList()
{
  intList* args = new intList;
  for (int i = 0 ; i < minFree ; i++) {
    args->add(dest[i] + 1);	// 
  }
  return args;
}

void MovTable::encodeStoringArgs(int nargs, instList& code)
{
  Rind Rmsgobj = regTable.newReg();
  code.add(new CDget_outlet(Rmsgobj, "msgobj"));
  for (Rind r = 0 ; r < nargs ; r++) {
    code.add(new CDset_arg(dest[r + maxUsed + 1], r));
  }
}
