/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef Classref_h
#define Classref_h 1

#include "Name.h"
#include "freshString.h"
#include "gArray.h"
#include "PIclassref.h"

class ostream;
class instList;
class Classref;
declare(gArray,Classref);

extern int classrefTableSize;
struct ClassrefTable : gArray(Classref) {
  ClassrefTable(int);
  void clear();
  Classref* remove(char*);
  void putPIclassrefs(instList&);
  Classref*& elt(int i) {
    return gArray(Classref)::operator [] (i);
  }
};

extern ClassrefTable* classrefTable;

class Classref {
friend class ClassrefTable;

  char* className;

  static int hash(char*);
public:
  static Classref* intern(char*);

  Classref(char* nm) {
    className = fresh_string(nm);
  }
  ~Classref() {
#if __GNUG__ == 2
    delete[] className;
#else
    delete[strlen(className) + 1] className;
#endif
  }
  Classref* intern();

  Name string() { return Name(className); }
  void print(ostream& ost) { ost << "'" << className << "'"; }

  void addPIclassref(instList& code) {
    code.add(new PIclassref(className));
  }
};

inline ostream& operator<<(ostream& ost, Classref* cp)
{
  cp->print(ost);
  return ost;
}

#endif Classref_h
