/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stdlib.h>
#include "SNerror.h"
#include "Classref.h"
#include "PIclassref.h"
#include "nameStream.h"

int classrefTableSize = 128;
ClassrefTable* classrefTable;

ClassrefTable::ClassrefTable(int n) : (n)
{
  for (int i = 0 ; i < length() ; i++) {
    (*this)[i] = 0;
  }
}

void ClassrefTable::clear()
{
  for (int i = 0 ; i < length() ; i++) {
    Classref* cp = (*this)[i];
    if (cp) delete cp;
    (*this)[i] = 0;
  }
}

void ClassrefTable::putPIclassrefs(instList& code)
{
  for (int i = 0 ; i < length() ; i++) {
    Classref* cp = (*this)[i];
    if (cp) cp->addPIclassref(code);
  }
}

int Classref::hash(char* string)
{
  int len = strlen(string);
  int h = 0;
  for (int i = 0 ; i < len ; i++) {
    h += string[i];
  }
  while (h > 0x7f) {
    h = (h & 0x7f) + (h >> 7);
  }
  return h % classrefTableSize;
}

Classref* Classref::intern()
{
  int h = hash(className);
  for (int i = h ; i < classrefTable->length() ; i++) {
    Classref* cp = classrefTable->elt(i);
    if (cp == 0) {
      classrefTable->elt(i) = this;
      return this;
    }
    else if (strcmp(className, cp->className) == 0) {
      return cp;
    }
  }
  for (i = 0 ; i < h ; i++) {
    Classref* cp = classrefTable->elt(i);
    if (cp == 0) {
      classrefTable->elt(i) = this;
      return this;
    }
    else if (strcmp(className, cp->className) == 0) {
      return cp;
    }
  }
  SNwarning("no more classref table entry left, bye");
  exit(1);
  // not reached; the following is a dummy
  return 0;
}

Classref* Classref::intern(char* nm)
{
  Classref* cp = new Classref(nm);
  Classref* vClassp = cp->intern();
  if (cp != vClassp) delete cp;
  return vClassp;
}

Classref* ClassrefTable::remove(char* target)
{
  int h = Classref::hash(target);
  for (int i = h ; i < classrefTable->length() ; i++) {
    Classref* cp = classrefTable->elt(i);
    if (cp && strcmp(target, cp->className) == 0) {
      classrefTable->elt(i) = 0;
      return cp;
    }
  }
  for (i = 0 ; i < h ; i++) {
    Classref* cp = classrefTable->elt(i);
    if (cp && strcmp(target, cp->className) == 0) {
      classrefTable->elt(i) = 0;
      return cp;
    }
  }
  return 0;
}
