/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef numlabel_h
#define numlabel_h 1

#include <bool.h>
#include "Name.h"

class numberedLabel {
protected:
  char* buffer;
  bool ownbuffer;
  unsigned long count;
  Name trunk;

  int maxlen() { return trunk.length() + sizeof(count) * 3 + 1; }
public:
  numberedLabel(Name& = "L", unsigned long = 0, char* = 0);
  numberedLabel(const numberedLabel&);
  numberedLabel& operator = (const numberedLabel&);
  ~numberedLabel();
  char* Buffer() { return buffer; }
  void Buffer(char* b) { buffer = b; ownbuffer = FALSE; }
  unsigned long number() { return count; }
  void number(unsigned long i) { count = i; }
  Name Trunk() { return trunk; }
  void Trunk(Name&);
  Name operator () ();
  Name next() { count++; return operator () (); }
};

#endif numlabel_h
