/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "numlabel.h"

numberedLabel::numberedLabel(Name& t, unsigned long i, char* b)
: count(i), trunk(t)
{
  if (b == 0) {
    buffer = new char[maxlen()];
    ownbuffer = TRUE;
  }
  else {
    buffer = b;
    ownbuffer = FALSE;
  }
}

numberedLabel::numberedLabel(const numberedLabel& l)
: ownbuffer(l.ownbuffer), count(l.count), trunk(l.trunk)
{
  if (ownbuffer) {
    buffer = new char[maxlen()];
  }
  else {
    buffer = l.buffer;
  }
}

numberedLabel& numberedLabel::operator = (const numberedLabel& l)
{
  if (ownbuffer) {
#if __GNUG__ == 2
    delete[] buffer;
#else
    delete[maxlen()] buffer;
#endif
  }
  ownbuffer = l.ownbuffer;
  count = l.count;
  trunk = l.trunk;
  if (ownbuffer) {
    buffer = new char[maxlen()];
  }
  else {
    buffer = l.buffer;
  }
  return *this;
}

numberedLabel::~numberedLabel()
{
  if (ownbuffer) {
#if __GNUG__ == 2
    delete[] buffer;
#else
    delete[maxlen()] buffer;
#endif
  }
}

void numberedLabel::Trunk(Name& t)
{
  if (ownbuffer) {
#if __GNUG__ == 2
    delete[] buffer;
#else
    delete[maxlen()] buffer;
#endif
    trunk = t;
    buffer = new char[maxlen()];
  }
  else trunk = t;
}

Name numberedLabel::operator () ()
{
  sprintf(buffer, "%s%ld", (char*)trunk, count);
  return Name(buffer);
}
