/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef gMHList_h
#define gMHList_h 1

typedef void* pix;
typedef void* ptr;

#include <generic.h>
#include "MHList.h"

#define gMHList(type) name2(type,gMHList)
#define gMHList_iterator(type) name2(type,gMHList_iterator)

#define gMHListdeclare(type)						      \
struct gMHList(type) : MHList {						      \
  gMHList(type)() {}							      \
  gMHList(type)(const gMHList(type)& l) : (l) {}			      \
  void push(type* anms) { MHList::push(anms); }				      \
  type* pop() { return MHList::pop(); }					      \
  void insert(pix i, type* anms) { MHList::insert(i, anms); }		      \
};									      \
									      \
struct gMHList_iterator(type) : MHList_iterator {			      \
  gMHList_iterator(type)(gMHList(type)* l) : ( (MHList*)l ) {}		      \
  type* operator()() { return (type*)MHList_iterator::operator()(); }	      \
  type* next() { step(); return (*this)(); }				      \
};									      \

#endif gMHList_h
