/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef gList_h
#define gList_h 1

#include "List.h"
#include <generic.h>

#define gList(type) name2(type,gList)
#define gList_iterator(type) name2(type,gList_iterator)

#define gListdeclare(type)						      \
struct gList(type) : List {						      \
  void add(type* anms) { List::add(anms); }				      \
  void push(type* anms) { List::push(anms); }				      \
  type* pop() { return (type*)List::pop(); }				      \
  void insert(pix x, type* anms) { List::insert(x, anms); }		      \
  gList(type)() {}							      \
  type* last() { return (type*)List::last(); }				      \
};									      \
									      \
struct gList_iterator(type) : List_iterator {				      \
  gList_iterator(type)(gList(type)* l) : ( (List*)l ) {}		      \
  type* operator()() { return (type*)List_iterator::operator()(); }	      \
  type* next() { return (type*)List_iterator::next(); }			      \
  void reset() { List_iterator::reset(); }				      \
  type* find(type* p) { return (type*)List_iterator::find(p); }		      \
  type* remove() { return (type*)List_iterator::remove(); }		      \
};									      \

#endif gList_h
